/*********************************************************************/
/*                                                                   */
/*  This Program Written by Paul Edwards, 3:711/934@fidonet.         */
/*  Released to the Public Domain                                    */
/*                                                                   */
/*********************************************************************/
/*********************************************************************/
/*                                                                   */
/*  devil dialer                                                     */
/*  this program is designed to freq files from a Wazoo BBS          */
/*                                                                   */
/*********************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <pdcomm.h>
#include <m2x.h>
#include <error.h>
#include <zmcore.h>
#include <zmext.h>
#include <strinl.h>
#include <stritr.h>

#ifndef MSDOS
#include <os2.h>
#else
#include <dos.h>
#endif

#define DDC_USAGE "DDC001 Usage: devil <port string>\n"

static void sendZmodem(void);
static void receiveZmodem(void);

static PDCOMM pdcomm;
static ZMCORE zmcore;
static ZMEXT zmext;
static char sendFileName[100];
static int destNet;
static int destNode;
static char phoneNumber[50];
static char *port;


static void checkArgs(int argc, char **argv);
static void main2(void);
static void getUserInput(void);
static void dial(void);
static void yoohoo(void);
static void sendHello(void);
static void delaySeconds(int secs);

int main(int argc, char **argv)
{
    errorDefaults();
    errorInit();
    if (ALLOK)
    {
        checkArgs(argc, argv);
        if (ALLOK)
        {
            pdcommDefaults(&pdcomm);
            pdcommInit(&pdcomm, port);
            if (ALLOK)
            {
                main2();
                pdcommTerm(&pdcomm);
            }
        }
    }
    errorTerm();
    return (0);
}

static void checkArgs(int argc, char **argv)
{
    if (argc < 2)
    {
        errorSet(DDC_USAGE);
    }
    else
    {
        port = *(argv + 1);
        printf("using port string of %s\n", port);
    }
    return;
}

static void main2(void)
{
    zmextDefaults(&zmext);
    zmextInit(&zmext, &pdcomm);
    zmcoreDefaults(&zmcore);
    zmcoreInit(&zmcore, &zmext);
    getUserInput();
    dial();
    yoohoo();
    sendZmodem();
    if (ALLOK)
    {
        receiveZmodem();
    }
    zmcoreTerm(&zmcore);
    zmextTerm(&zmext);
    return;
}

static void getUserInput(void)
{
    char buf[200];
    FILE *fq;
    
    printf("enter destination net\n");
    scanf("%d", &destNet);
    printf("enter destination node\n");
    scanf("%d", &destNode);
    printf("enter destination phone number\n");
    scanf("%s", phoneNumber);
    printf("enter filenames that you want, blank line to end\n");
    sprintf(sendFileName, "%.4X%.4X.REQ", destNet, destNode);
    fq = fopen(sendFileName, "wb");
    if (fq != NULL)
    {
        fgets(buf, sizeof buf, stdin);
        while (fgets(buf, sizeof buf, stdin) != NULL)
        {
            strinl(buf);
            stritr(buf);
            if (strlen(buf) == 0) break;
            fprintf(fq, "%s\r\n", buf);
        }
        fclose(fq);
    }
    return;
}           

static void dial(void)
{
    char buf[50];
    int ch;
    int live = 0;
#ifndef LOCAL    
    int x;
#endif    
    
    delaySeconds(1);
    sprintf(buf, "ATDT%s\r", phoneNumber);
    printf("sending string %s\n", buf);
    pdcommWriteBuf(&pdcomm, (unsigned char *)buf, strlen(buf));
#ifndef LOCAL    
    printf("waiting for connect\n");
    delaySeconds(1);
    /* clear inbound */
    for (x = 0; x < 500; x++)
    {
        if (pdcommReadCh(&pdcomm) == EOF) break;
    }
    for (x=0; x < 30;)
    {
        if ((ch = pdcommReadCh(&pdcomm)) == 'C') 
        {
            live = 1;
            printf("received C\n");
        }
        else if ((ch == 'O') && live)
        {
            printf("got connect\n");
            break;
        }
        else if (ch > 0)
        {
            printf("%c", ch);
            live = 0;
        }
        else
        {
            delaySeconds(1);
            live = 0;
            x++;
        }
    }
#endif    
    return;
}

static void yoohoo(void)
{
    pdcommWriteCh(&pdcomm, 0xf1);
    delaySeconds(3);
    pdcommWriteCh(&pdcomm, 0xf1);
    delaySeconds(3);
    pdcommWriteCh(&pdcomm, 0xf1);
    delaySeconds(3);
    pdcommWriteCh(&pdcomm, 0xf1);
    delaySeconds(3);
    pdcommWriteCh(&pdcomm, 0xf1);
    delaySeconds(4);
    sendHello();
    delaySeconds(4);
    pdcommWriteCh(&pdcomm, 0x05);
    delaySeconds(4);
    pdcommWriteCh(&pdcomm, 0x06);
    delaySeconds(2);
    return;
}

#define cputc(c) pdcommWriteCh(&pdcomm, c)
#define cputs(s) pdcommWriteBuf(&pdcomm, (unsigned char *)s, strlen(s))

static void sendHello(void)
{
  printf("sending hello\n");
  cputc(0x1f); 
  cputc(0x6f); 
  cputc(0x00); 
  cputc(0x01); 
  cputc(0x00); 
  cputc(0x00); 
  cputc(0x00); 
  cputc(0x00); 
  cputc(0x00); 
  cputc(0x00); 
  cputc(0x00); 
  cputs("Devil Dialer                                               ");
  cputc(0x00); 
  cputs("The Devil          "); 
  cputc(0x00); 
  cputc(0x9a); 
  cputc(0x02); 
  cputc(0x9a); 
  cputc(0x02); 
  cputc(0x9a); 
  cputc(0x02); 
  cputc(0x00); 
  cputc(0x00); 
  cputc(0x00); 
  cputc(0x00);  
  cputc(0x00);
  cputc(0x00);
  cputc(0x00);  
  cputc(0x00);
  cputc(0x00);
  cputc(0x00);  
  cputc(0x00); 
  cputc(0x00);
  cputc(0x00);  
  cputc(0x00);
  cputc(0x00);
  cputc(0x00);  
  cputc(0x00);
  cputc(0x00);
  cputc(0x04); 
  cputc(0x00); 
  cputc(0x00); 
  cputc(0x00);
  cputc(0x00);
  cputc(0x00);  
  cputc(0x00);
  cputc(0x00);
  cputc(0x00);  
  cputc(0x00);
  cputc(0x00);
  cputc(0x00);  
  cputc(0x00);
  cputc(0x00);
  cputc(0xc4); 
  cputc(0xfa); 
  return;
}
                        
static void sendZmodem(void)
{
    zmextFileSetSpec(&zmext, sendFileName);
    zmcoreSend(&zmcore);
    return;
}

void receiveZmodem(void)
{
    zmcoreReceive(&zmcore);
    return;
}

static void delaySeconds(int secs)
{
#ifndef MSDOS
    DosSleep(secs * 1000L);
#else
    sleep(secs);
#endif    
    return;
}    
