#include <stdio.h>
#include <stdlib.h>

#include "pdcomm.h"
#include "error.h"

#ifdef AMIGA
#include <proto/dos.h>
/* This should really use VBlank */
#define sleep(z) Delay(50*z)
#endif
#ifdef WIN32
#define SLEEP_TIME 5000
#else
#define SLEEP_TIME 5
#endif

int main(int argc, char **argv)
{
    PDCOMM pdcomm;
    unsigned char buf[100];
    int cnt;

    if (argc < 2)
    {
        printf("usage: comtest <port string>\ne.g. "
#if defined(OS2)
               "comtestp COM2:19200"
#elif defined(MSDOS)
               "comtest COM2:02F8,3,19200"
#elif defined(AMIGA)
               "comtest serial.device,0,19200"
#elif defined(WIN32)
               "comtestw COM2:19200"
#endif
               "\n");
        return (EXIT_FAILURE);
    }

    pdcommDefaults(&pdcomm);
    printf("opening port\n");
    pdcommInit(&pdcomm, *(argv + 1));

    if (ALLOK)
    {
        printf("sending string\n");
        pdcommWriteBuf(&pdcomm, "ATZ\r\n", 5);

        printf("waiting 5 seconds\n");
        sleep(SLEEP_TIME);
        printf("finished waiting\n");

        cnt = pdcommReadBuf(&pdcomm, buf, sizeof buf);
        printf("received %d characters\n", cnt);
        if (cnt > 0)
        {
            printf("received text is:\n");
            fwrite(buf, cnt, 1, stdout);
            printf("\n");
        }
        pdcommTerm(&pdcomm);
    }
    else
        printf("aborting\n");

    return (EXIT_SUCCESS);
}
