/*********************************************************************/
/*                                                                   */
/*  This Program Written by Paul Edwards, 3:711/934@fidonet.         */
/*  Released to the Public Domain                                    */
/*                                                                   */
/*********************************************************************/
/*********************************************************************/
/*                                                                   */
/*  lldos.h - see lldos.c for doco                                   */
/*                                                                   */
/*********************************************************************/

#ifndef LLDOS_INCLUDED
#define LLDOS_INCLUDED

#define PWRITEB(x, y) wportb(x, y)
#define PREADB(x) rportb(x)
#define INTSTOP() disable()
#define INTALLOW() enable()

#if (defined(MSDOS) && defined(__WATCOMC__))
#define DOSPREF cdecl
#else
#define DOSPREF
#endif

int DOSPREF getfar(long address);
void DOSPREF putfar(long address, unsigned ch);
int DOSPREF rportb(int port);
void DOSPREF wportb(int port, unsigned ch);
void DOSPREF disable(void);
void DOSPREF enable(void);

#endif

