/*********************************************************************/
/*                                                                   */
/*  This Program Written by Paul Edwards, 3:711/934@fidonet.         */
/*  Released to the Public Domain                                    */
/*                                                                   */
/*********************************************************************/
/*********************************************************************/
/*                                                                   */
/*  pdcommu.c - comms routines for unix                              */
/*                                                                   */
/*********************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <sys/fcntl.h>
#include <termios.h>
#include <unistd.h>

#include "pdcommu.h"
#include "error.h"

void pdcommDefaults(PDCOMM *pdcomm)
{
    pdcomm->fh = 0;
    return;
}

/* supported strings are:
   /dev/modem
   /dev/modem,19200
   etc
*/

void pdcommInit(PDCOMM *pdcomm, char *name)
{
    char *p;
    long speed;
    
    p = strchr(name, ',');
    if (p != NULL)
    {
        *p = '\0';
    }
    pdcomm->fh = open(name, O_RDWR | O_NDELAY);
    if (pdcomm->fh == 0)
    {
        errorSet(COMERROR);
    }
    if (p != NULL)
    {
        if (ALLOK)
        {
            speed = atol(p + 1);
            pdcommSetSpeed(pdcomm, speed);
        }
        *p = '\0';
    }
    return;
}

void pdcommSetSpeed(PDCOMM *pdcomm, long bps)
{
    struct termios tio;
    speed_t speed;
    
    switch (bps)
    {
         case 0: break;
         case 300: speed = B300; break;
         case 1200: speed = B1200; break;
         case 2400: speed = B2400; break;
         case 4800: speed = B4800; break;
         case 9600: speed = B9600; break;
         case 19200: speed = B19200; break;
         case 38400: speed = B38400; break;
         default: speed = B38400; break;
    }
    if (bps == 0) return;
    tcgetattr(pdcomm->fh, &tio);
    cfsetispeed(&tio, speed);
    cfsetospeed(&tio, speed);
    tcsetattr(pdcomm->fh, TCSANOW, &tio);
    return;
}

void pdcommSetParms(PDCOMM *pdcomm, int parity, int data, int stop)
{
    return;
}

void pdcommRaiseDTR(PDCOMM *pdcomm)
{
    return;
}

void pdcommDropDTR(PDCOMM *pdcomm)
{
    return;
}

int pdcommWriteCh(PDCOMM *pdcomm, int ch)
{
    char buf[1];
    
    buf[0] = (char)ch;
    write(pdcomm->fh, buf, 1);
    return (ch);
}

size_t pdcommWriteBuf(PDCOMM *pdcomm, void *buf, size_t num)
{
    write(pdcomm->fh, buf, num);
    return (num);
}

int pdcommReadCh(PDCOMM *pdcomm)
{
    char buf[1];
    
    if (read(pdcomm->fh, buf, 1) != 1)
    {
        return (EOF);
    }
    return ((int)(unsigned char)buf[0]);
}

size_t pdcommReadBuf(PDCOMM *pdcomm, void *buf, size_t num)
{
    size_t ret;
    
    ret = read(pdcomm->fh, buf, num);
    return (ret);
}

void pdcommTerm(PDCOMM *pdcomm)
{
    return;
}
