/*********************************************************************/
/*                                                                   */
/*  This Program Written by Paul Edwards, 3:711/934@fidonet.         */
/*  Released to the Public Domain                                    */
/*                                                                   */
/*********************************************************************/
/*********************************************************************/
/*                                                                   */
/*  pdcommu.h - see pdcommu.c for doco                               */
/*                                                                   */
/*********************************************************************/

#ifndef PDCOMMU_INCLUDED
#define PDCOMMU_INCLUDED

#include <stddef.h>

#define COMERROR "COM001 A comms error has occured\n"
#define PDCOMM_NO_PARITY 0

typedef struct
{
    int fh;
} PDCOMM;

void pdcommDefaults(PDCOMM *pdcomm);
void pdcommInit(PDCOMM *pdcomm, char *name);
void pdcommSetSpeed(PDCOMM *pdcomm, long bps);
void pdcommSetParms(PDCOMM *pdcomm, int parity, int data, int stop);
void pdcommRaiseDTR(PDCOMM *pdcomm);                    
void pdcommDropDTR(PDCOMM *pdcomm);                    
int pdcommWriteCh(PDCOMM *pdcomm, int ch);
size_t pdcommWriteBuf(PDCOMM *pdcomm, void *buf, size_t num);
int pdcommReadCh(PDCOMM *pdcomm);
size_t pdcommReadBuf(PDCOMM *pdcomm, void *buf, size_t num);
void pdcommTerm(PDCOMM *pdcomm);

#define pdcommSetWBuf(a, b, c, d)
#define pdcommSetRBuf(a, b, c, d)
#define pdcommWFlush(a)
#define pdcommRFlush(a)

#endif
