/*********************************************************************/
/*                                                                   */
/*  This Program Written by Paul Edwards.                            */
/*  Released to the Public Domain                                    */
/*                                                                   */
/*********************************************************************/
/*********************************************************************/
/*                                                                   */
/*  pos - some low-level dos functions                               */
/*                                                                   */
/*  In my opinion, all the MSDOS functions should have had both a    */
/*  low-level assember interrupt definition, and a functional        */
/*  interface for higher level languages such as C.  It is important */
/*  to have both interfaces as it allows anyone creating a new       */
/*  language to implement the functions themselves.  It is also a    */
/*  good idea to make the API start with a specific mneumonic like   */
/*  the Dos* and Win* etc functions you see in the OS/2 API.  It is  */
/*  not a good idea to pretend to be performing data abstraction by  */
/*  typedefing long as LONG etc.  Hence, the following is what I     */
/*  think should have been done to formalise the HLL Dos API.        */
/*                                                                   */
/*  Obviously it's a bit late to be standardizing this now, and not  */
/*  only that, but it's not much of a standard when I'm the only     */
/*  user of it either!  However, this interface is first and         */
/*  foremost to provide myself with a clearcut API so that I can     */
/*  make it 32-bit at the drop of a hat.                             */
/*                                                                   */
/*********************************************************************/

#include <stddef.h>

/* API functions */

void PosDisplayOutput(int ch); /* func 2 */

int PosSelectDisk(int drive); /* func e */

int PosGetDefaultDrive(void); /* func 19 */

void PosGetSystemDate(int *year, int *month, int *day, int *dow); /* func 2a */

void PosGetSystemTime(int *hour, /* func 2c */
                      int *min, 
                      int *sec, 
                      int *hundredths);

void *PosGetDTA(void); /* func 2f */

unsigned int PosGetDosVersion(void); /* func 30 */

int PosChangeDir(char *to); /* func 3b */

int PosOpenFile(const char *name, /* func 3d */
                int mode,
                int *handle);
                
int PosCloseFile(int handle); /* func 3e */

void PosReadFile(int fh, /* func 3f */
                 void *data, 
                 size_t bytes, 
                 size_t *readbytes);
                 
int PosWriteFile(int handle, /* func 40 */
                 const void *data,
                 size_t len);
                 
int PosDeleteFile(const char *fname); /* func 41 */

long PosMoveFilePointer(int handle, long offset, int whence); /* func 42 */

int PosGetCurDir(int drive, char *dir); /* func 47 */

void *PosAllocMem(unsigned int size); /* func 48 */

int PosFreeMem(void *ptr); /* func 49 */

void PosExec(char *prog, void *parmblock); /* func 4b */

void PosTerminate(int rc); /* func 4c */

int PosGetReturnCode(void); /* func 4d */

int PosFindFirst(char *pat, int attrib); /* func 4e */

int PosFindNext(void); /* func 4f */

int PosRenameFile(const char *old, const char *new); /* func 56 */


/* The following functions are extensions... */

void PosDisplayInteger(int x); /* func f3.00 */

void PosReboot(void); /* func f3.01 */

void PosSetRunTime(void *pstart, void *capi); /* func f3.02 */


/* An easier-for-HLLs-to-use interface should also have been provided
   for executables.  Here is the makings of such an interface... */

typedef struct {
    int len;
    int (*__start)(void *exep);
    int (*printf)(const char *fmt, ...);
    void *(*malloc)(size_t size);
} POS_C_API;

typedef struct {
    int len;
    int abscor;
    int subcor;
    unsigned char *psp;
    unsigned char *cl;
    /* if anything is added before callback, strt32.s will need to change */
    void (*callback)(void);
    int (*pstart)(int *i1, int *i2, int *i3, void *eparms);
    /* beyond this point, no corrections have been done */
    void *posapi;
    void *bosapi;
    POS_C_API *crt;
} POS_EPARMS;
