/*********************************************************************/
/*                                                                   */
/*  This Program Written by Paul Edwards                             */
/*  Released to the Public Domain                                    */
/*                                                                   */
/*********************************************************************/
/*********************************************************************/
/*                                                                   */
/*  zmext - routines required by zmcore                              */
/*                                                                   */
/*********************************************************************/

#include <stdlib.h>
#include <stdio.h>

#include <error.h>
#include <trav.h>
#include <unused.h>

#include "zmext.h"

static int travfunc(char *fnm, void *ucb);

void zmextDefaults(ZMEXT *zmext)
{
    unused(zmext);
    return;
}

void zmextInit(ZMEXT *zmext, PDCOMM *pdcomm)
{
    zmext->pdcomm = pdcomm;
    return;
}

void zmextTerm(ZMEXT *zmext)
{
    unused(zmext);
    return;
}

void zmextFileSetSpec(ZMEXT *zmext, char *spec)
{
    zmext->fileUpto = 0;
    trav(spec, NULL, travfunc, (void *)zmext);
    strcpy(zmext->fileList[zmext->fileUpto], "");
    zmext->fileUpto = 0;
    return;
}

static int travfunc(char *fnm, void *ucb)
{
    ZMEXT *zmext;
    
    zmext = (ZMEXT *)ucb;
    strcpy(zmext->fileList[zmext->fileUpto++], fnm);
    return (1); 
}
