#include <stdio.h>

#include "pdcomm.h"

extern unsigned int Baudrate;
extern int Port;

static PDCOMM pdcomm;
static int init;

void modemInit(void)
{
    char   comName[20];
    int    port;
    long   speed;
    
    init = 1;
    port = Port;
    speed = Baudrate;
    pdcommInit(&pdcomm);
#ifdef OS2    
    sprintf(comName, "COM%d", port);
    pdcommOpen(&pdcomm, comName, speed);
#else
    pdcommBuffers(&pdcomm, 2000, 2000);
    printf("attempting to open port %d\n", port);
    if (port == 1)
    {
        pdcommOpenPort(&pdcomm, 0x3f8, 4);
    }
    else if (port == 2)
    {
        pdcommOpenPort(&pdcomm, 0x2f8, 3);
    }
    else if (port == 3)
    {
        pdcommOpenPort(&pdcomm, 0x3e8, 9);
    }
    else if (port == 4)
    {
        pdcommOpenPort(&pdcomm, 0x2e8, 5);
    }
    pdcommSetParms(&pdcomm, speed, PDCOMM_NO_PARITY, 8, 1);
#endif        
}

int readline(int tenths)
{
    int ch;
    int x;
    
    ch = pdcommRecCh(&pdcomm);
    if ((ch == -1) && (tenths != 0))
    {
        for (x=0; x < 100; x++)
        {
#ifdef OS2        
            DosSleep(1);
#else
            delay(1);            
#endif            
            ch = pdcommRecCh(&pdcomm);
            if (ch != -1)
            {
                return (ch);
            }
        }
        tenths--;
        for (x=0; x < tenths; x++)
        {
#ifdef OS2        
            DosSleep(100);
#else
            delay(100);            
#endif            
            ch = pdcommRecCh(&pdcomm);
            if (ch != -1)
            {
                return (ch);
            }
        }
    }
    if (ch == -1)
    {
        return (-2);
    }
    return (ch);
}

void sendline(int ch)
{
    pdcommTxCh(&pdcomm, ch);
    return;
}

void purgeline(void)
{
    return;
}

void flushmo(void)
{
    return;
}

void mysleep(int secs)
{
#ifdef OS2
    DosSleep(secs * 1000);
#else
    sleep(secs);
#endif        
    return;
}

void modemTerm(void)
{
#ifdef OS2
    pdcommClose(&pdcomm);
#else    
    pdcommClosePort(&pdcomm);
#endif    
    pdcommTerm(&pdcomm);
    return;
}

