/*********************************************************************/
/*                                                                   */
/*  This Program Written by Paul Edwards, 3:711/934@fidonet.         */
/*  Released to the Public Domain                                    */
/*                                                                   */
/*********************************************************************/
/*********************************************************************/
/*                                                                   */
/*  pdcommd.h - see pdcommd.c for docs                               */
/*                                                                   */
/*********************************************************************/

#ifndef PDCOMMD_INCLUDED
#define PDCOMMD_INCLUDED

#include <stddef.h>

#include "uart.h"

#define PDCOMM_NO_PARITY UART_NO_PARITY
#define PDCOMM_EVEN_PARITY UART_EVEN_PARITY
#define PDCOMM_ODD_PARITY UART_ODD_PARITY

typedef struct
{
    UART uart;

    int intrpt;
    int parity;
    int parityd;
    int databits;
    int stopbits;
    long bps;
    
    int a8259;
    int imr;
    int vector;
    char oldIRQ[4];
    
    int ch;
    size_t recBufSiz;
    size_t txBufSiz;
    char   *recBuf;
    char   *txBuf;
    char   *recStartPos;
    char   *txStartPos;
    char   *recEndPos;
    char   *txEndPos;
    char   *recReadPos;
    char   *txReadPos;
    char   *recWritePos;
    char   *txWritePos;
    int     txempty;
    int     ctsShake;
    int     ctsOK;
    
} PDCOMM;

void pdcommInit(PDCOMM *pdcomm);
void pdcommBuffers(PDCOMM *pdcomm, size_t txBufSiz, size_t recBufSiz);
void pdcommOpenPort(PDCOMM *pdcomm, int port, int intrpt);
void pdcommClosePort(PDCOMM *pdcomm);
void pdcommSetParms(PDCOMM *pdcomm, long bps, int parity, int databits,
    int stopbits);
size_t pdcommTxCh(PDCOMM *pdcomm, int ch);
size_t pdcommTxBuf(PDCOMM *pdcomm, void *vbuf, size_t nelem);
int pdcommRecCh(PDCOMM *pdcomm);
size_t pdcommRecBuf(PDCOMM *pdcomm, void *vbuf, size_t nelem);
void pdcommTerm(PDCOMM *pdcomm);
void pdcommInt(void);

#endif
