/*********************************************************************/
/*                                                                   */
/*  This Program Written by Paul Edwards, 3:711/934@fidonet.         */
/*  Released to the Public Domain                                    */
/*                                                                   */
/*********************************************************************/
/*********************************************************************/
/*                                                                   */
/*  pdcommda - com stuff that should be written in assembler!        */
/*  Until then they are Turbo-C specific.                            */
/*                                                                   */
/*  These routines should be used in conjunction with pdcommd.c      */
/*                                                                   */
/*********************************************************************/

#include "pdcommda.h"
#include "pdcommd.h"

void interrupt pdcommdaInt(void)
{
    INTSTOP();    
    pdcommInt();
    INTALLOW();
    return;
}

void pdcommdaInstallInt(long address)
{
    int x;
    unsigned char far *add = (unsigned char far *)address;
    void interrupt far (*ffunc)(void) = pdcommdaInt;
    unsigned char far *gfunc;

    gfunc = (unsigned char *)&ffunc;
    for (x=0; x<4; x++)
    {
        *(add + x) = *(gfunc + x);
    }
    return;
}
