/*********************************************************************/
/*                                                                   */
/*  This Program Written by Paul Edwards, 3:711/934@fidonet.         */
/*  Released to the Public Domain                                    */
/*                                                                   */
/*********************************************************************/
/*********************************************************************/
/*                                                                   */
/*  pdcommo - Com routines for OS/2                                  */
/*                                                                   */
/*********************************************************************/

#include <stdio.h>
#include <string.h>

#include "error.h"
#include "pdcommo.h"

static void pdcommSetBaudRate(PDCOMM *pdcomm, long bps);
static void pdcommSetLine(PDCOMM *pdcomm, 
                          int parity,
                          int data,
                          int stop);
#if 0                          
static void pdcommQueryLine(PDCOMM *pdcomm, 
                            int *parity,
                            int *data,
                            int *stop);
static void pdcommDisableXON(PDCOMM *pdcomm);
#endif                            
                            
void pdcommInit(PDCOMM *pdcomm)
{
    (void)pdcomm;
    return;
}

void pdcommOpen(PDCOMM *pdcomm, char *filename, long bps)
{
    APIRET rc;
    ULONG  action;
    ULONG  newsize = 0;
    ULONG  fileAttr = 0;
    ULONG  openAction = OPEN_ACTION_OPEN_IF_EXISTS;
    ULONG  openMode = OPEN_SHARE_DENYREADWRITE | OPEN_ACCESS_READWRITE;
    char   fileName[FILENAME_MAX];
    
    strcpy(fileName, filename);
    rc = DosOpen(fileName,
                 &pdcomm->hfile, 
                 &action, 
                 newsize, 
                 fileAttr,
                 openAction, 
                 openMode, 
                 NULL);
    if (rc != 0)
    {
        errorSet(COMERROR);
        printf("rc from DosOpen is %lu\n", (unsigned long)rc);
    }
    else
    {
        pdcommSetParms(pdcomm, bps, PDCOMM_NO_PARITY, 8, 1);
        if (ALLOK)
        {
            pdcommRaiseDTR(pdcomm);
        }
    }
    return;
}                 

void pdcommSetParms(PDCOMM *pdcomm, 
                    long bps,
                    int parity, 
                    int data,
                    int stop)
{                    
    pdcommSetBaudRate(pdcomm, bps);
    if (ALLOK)
    {
        pdcommSetLine(pdcomm, parity, data, stop);
    }    
    return;
}

static void pdcommSetBaudRate(PDCOMM *pdcomm, long bps)
{
    unsigned long baudRate;
    APIRET rc;
    
    baudRate = bps;
    rc = DosDevIOCtl(pdcomm->hfile, 
                     IOCTL_ASYNC,
                     0x43, /* set extended bit rate */
                     &baudRate,
                     sizeof baudRate,
                     NULL,
                     NULL,
                     0,
                     NULL);
    if (rc != 0)
    {
        printf("rc from DosDevIoCtl is %lu\n", (unsigned long)rc);
        errorSet(COMERROR);
    }
    return;
}

static void pdcommSetLine(PDCOMM *pdcomm, 
                          int parity,
                          int data,
                          int stop)
{
    APIRET rc;
    struct {
        BYTE data;
        BYTE parity;
        BYTE stop;
    } lineCharacter;

    lineCharacter.data = (BYTE)data;
    lineCharacter.parity = (BYTE)parity;
    if (stop == 1)
    {
        stop = 0;
    }
    lineCharacter.stop = (BYTE)stop;  
    rc = DosDevIOCtl(pdcomm->hfile, 
                     IOCTL_ASYNC,
                     0x42,
                     &lineCharacter,
                     sizeof lineCharacter,
                     NULL,
                     NULL,
                     0,
                     NULL);
    if (rc != 0)
    {
        printf("rc from DosDevIoCtl is %lu\n", (unsigned long)rc);
        errorSet(COMERROR);
    }
    return;
}

#if 0
static void pdcommQueryLine(PDCOMM *pdcomm, 
                            int *parity,
                            int *data,
                            int *stop)
{
    APIRET rc;
    struct {
        BYTE data;
        BYTE parity;
        BYTE stop;
        BYTE brk;
    } lineCharacter;
    
    rc = DosDevIOCtl(pdcomm->hfile, 
                     IOCTL_ASYNC,
                     0x62, /* set extended bit rate */
                     NULL,
                     0,
                     NULL,
                     &lineCharacter,
                     sizeof lineCharacter,
                     NULL);
    if (rc != 0)
    {
        printf("rc from DosDevIoCtl is %lu\n", (unsigned long)rc);
        errorSet(COMERROR);
    }
    else
    {
        *parity = (int)lineCharacter.parity;
        *data = (int)lineCharacter.data;
        *stop = (int)lineCharacter.stop;
    }    
    return;
}
#endif

void pdcommRaiseDTR(PDCOMM *pdcomm)
{
    APIRET rc;
    struct {
        BYTE on;
        BYTE off;
    } parm;
    unsigned short controlWord;
    
    parm.on = (BYTE)0x01;
    parm.off = (BYTE)0xff;
    rc = DosDevIOCtl(pdcomm->hfile, 
                     IOCTL_ASYNC,
                     0x46, 
                     &parm,
                     sizeof parm,
                     NULL,
                     &controlWord,
                     sizeof controlWord,
                     NULL);
    if (rc != 0)
    {
        printf("rc from DosDevIoCtl is %lu\n", (unsigned long)rc);
        errorSet(COMERROR);
    }
    return;
}

void pdcommDropDTR(PDCOMM *pdcomm)
{
    APIRET rc;
    struct {
        BYTE on;
        BYTE off;
    } parm;
    unsigned short controlWord;
    
    parm.on = 0x00;
    parm.off = 0xfe;
    rc = DosDevIOCtl(pdcomm->hfile, 
                     IOCTL_ASYNC,
                     0x46, 
                     &parm,
                     sizeof parm,
                     NULL,
                     &controlWord,
                     sizeof controlWord,
                     NULL);
    if (rc != 0)
    {
        printf("rc from DosDevIoCtl is %lu\n", (unsigned long)rc);
        errorSet(COMERROR);
    }
    return;
}

#if 0
static void pdcommDisableXON(PDCOMM *pdcomm)
{
    APIRET rc;
    struct {
        unsigned short write;
        unsigned short read;
        BYTE flags1;
        BYTE flags2;
        BYTE flags3;
        BYTE err;
        BYTE brk;
        BYTE xon;
        BYTE xoff;
    } parm;
    
    rc = DosDevIOCtl(pdcomm->hfile, 
                     IOCTL_ASYNC,
                     0x73, 
                     NULL,
                     0,
                     NULL,
                     &parm,
                     sizeof parm,
                     NULL);
    if (rc != 0)
    {
        printf("rc from DosDevIoCtl is %lu\n", (unsigned long)rc);
        errorSet(COMERROR);
    }
    else
    {
        parm.flags2 &= ~0x03;
        rc = DosDevIOCtl(pdcomm->hfile, 
                         IOCTL_ASYNC,
                         0x53, 
                         &parm,
                         sizeof parm,
                         NULL,
                         NULL,
                         0,
                         NULL);
        if (rc != 0)
        {
            printf("rc from DosDevIoCtl is %lu\n", (unsigned long)rc);
            errorSet(COMERROR);
        }
    }
    return;
}
#endif

void pdcommTxCh(PDCOMM *pdcomm, unsigned char ch)
{
    ULONG  actualWritten;
    int rc;
    int ret = 1;
    
    rc = DosWrite(pdcomm->hfile, &ch, 1, &actualWritten);
    if (rc != 0)
    {
        printf("rc from DosWrite is %lu\n", (unsigned long)rc);
    }
    else
    {
        ret = 0;
    }
    if (ret != 0)
    {
        errorSet(COMERROR);
    }
    return;
}    

void pdcommTxBuf(PDCOMM *pdcomm, unsigned char *buf, int num)
{
    int x;
    int rc;
    int ret = 0;
    
    for (x = 0; x < num; x++)
    {
        pdcommTxCh(pdcomm, buf[x]);
        rc = 0;
        if (rc != 0)
        {
            ret = 1;
            break;
        }
    }
    if (ret != 0)
    {
        errorSet(COMERROR);
    }
}

int pdcommRecCh(PDCOMM *pdcomm)
{
    ULONG  actualRead;
    unsigned char   buf[1];
    int    rc;
    int    ret = -1;
    short  numWaiting;

    numWaiting = 0;
    rc = DosDevIOCtl(pdcomm->hfile, 
                     IOCTL_ASYNC,
                     0x68, /* query # characters in receive queue */
                     NULL,
                     0,
                     NULL,
                     &numWaiting,
                     sizeof numWaiting,
                     NULL);

    if (rc != 0)
    {
        printf("rc from DosDevIOCtl is %lu\n", (unsigned long)rc);
        return (-1);
    }
    if (numWaiting == 0)
    {
        return (-1);
    }
    rc = DosRead(pdcomm->hfile, buf, 1, &actualRead);
    if (rc != 0)
    {
        printf("rc from DosRead is %lu\n", (unsigned long)rc);
    }
    else
    {
        if (actualRead == 1)
        {
            ret = buf[0];
        }
    }
    return (ret);
}    

int pdcommRecBuf(PDCOMM *pdcomm, unsigned char *buf, int num)
{
    ULONG  actualRead;
    int    rc;
    short  numWaiting;

    numWaiting = 0;
    rc = DosDevIOCtl(pdcomm->hfile, 
                     IOCTL_ASYNC,
                     0x68, /* query # characters in receive queue */
                     NULL,
                     0,
                     NULL,
                     &numWaiting,
                     sizeof numWaiting,
                     NULL);

    if (rc != 0)
    {
        printf("rc from DosDevIOCtl is %lu\n", (unsigned long)rc);
        return (0);
    }
    if (numWaiting == 0)
    {
        return (0);
    }
    if (num > numWaiting) 
    {
        num = numWaiting;
    }
    rc = DosRead(pdcomm->hfile, buf, num, &actualRead);
    if (rc != 0)
    {
        printf("rc from DosRead is %lu\n", (unsigned long)rc);
        return (0);
    }
    return ((int)actualRead);
}    

void pdcommClose(PDCOMM *pdcomm)
{
    int rc;
    int ret = 1;
    
    pdcommDropDTR(pdcomm);
    rc = DosClose(pdcomm->hfile);
    if (rc != 0)
    {
        printf("rc from DosClose is %lu\n", (unsigned long)rc);
    }
    if (rc == 0)
    {
        ret = 0;
    }
    if (ret != 0)
    {
        errorSet(COMERROR);
    }
    return;
}

void pdcommTerm(PDCOMM *pdcomm)
{
    (void)pdcomm;
    return;
}



