/*********************************************************************/
/*                                                                   */
/*  This Program Written by Paul Edwards, 3:711/934@fidonet.         */
/*  Released to the Public Domain                                    */
/*                                                                   */
/*********************************************************************/
/*********************************************************************/
/*                                                                   */
/*  pdcommo.h - see pdcommo.c for doco                               */
/*                                                                   */
/*********************************************************************/

#include <stdio.h>
#include <string.h>

#include "error.h"

#define COMERROR "COM001 A comms error has occured\n"
#define PDCOMM_NO_PARITY 0

#define INCL_DOS
#define INCL_BSE
#define INCL_DOSDEVIOCTL
#define INCL_EXE
#include <os2.h>

typedef struct
{
    HFILE hfile;
} PDCOMM;

void pdcommInit(PDCOMM *pdcomm);
void pdcommOpen(PDCOMM *pdcomm, char *filename, long bps);
void pdcommSetParms(PDCOMM *pdcomm, 
                    long bps,
                    int parity, 
                    int data,
                    int stop);
void pdcommRaiseDTR(PDCOMM *pdcomm);                    
void pdcommDropDTR(PDCOMM *pdcomm);                    
void pdcommTxCh(PDCOMM *pdcomm, unsigned char ch);
void pdcommTxBuf(PDCOMM *pdcomm, unsigned char *buf, int num);
int pdcommRecCh(PDCOMM *pdcomm);
int pdcommRecBuf(PDCOMM *pdcomm, unsigned char *buf, int num);
void pdcommClose(PDCOMM *pdcomm);
void pdcommTerm(PDCOMM *pdcomm);
